#include "variable_frequency_digital_source.h"

/*
 * variable_frequency_digital_source_set_initial_condition_single_output_from_IC_parameter
 *
 * This function will take the value of the IC parameter and write it to
 *	the output bus. 
 *
 * This function assumes that the setup routine called variable_frequency_digital_source_assign_default_pointers, so the function
 *	variable_frequency_digital_source_set_initial_condition should not. 
 */
SMX_DLL_ERROR variable_frequency_digital_source_set_initial_condition_single_output_from_IC_parameter(
	p_smx_dll_simulation_context context_p
	,
	p_smx_dll_device device_p
){

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	s_smx_dll_bus_conversion
		conversion;

	p_variable_frequency_digital_source_default_pointers
		default_pointers_p = NULL;

	// #ifdef _DEBUG
	//	if( IsDebuggerPresent() ) {
	//		DebugBreak();
	//	}
	// #endif

	// cast unmanaged user storage
	default_pointers_p = (p_variable_frequency_digital_source_default_pointers)device_p->unmanaged_user_storage;

	// bus conversion type
	conversion.type = SMX_DLL_TYPE_8BIT;

	// bus conversion encoding
	conversion.encoding = SMX_DLL_ENCODING_UNSIGNED;

	// bus conversion value
	conversion.ubyte8 = (SMX_DLL_UBYTE8)default_pointers_p->parameter_values_p->IC;

	// write initial condition to output bus
	rv = context_p->funcs->write_bus( default_pointers_p->output_bus_pointers_p->OUT_bus_p, &( conversion ), SMX_DLL_WRITE_INITIAL_CONDITION );

	return rv;

}

/*
 * variable_frequency_digital_source_set_initial_condition
 *
 *	This function is declared in variable_frequency_digital_source.h
 */
void variable_frequency_digital_source_set_initial_condition(p_smx_dll_simulation_context context_p, p_smx_dll_device device_p) {
	
	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	SMX_DLL_UINT64
		identifier = VARIABLE_FREQUENCY_DIGITAL_SOURCE_INITIAL_SETUP;

	p_variable_frequency_digital_source_default_pointers
		default_pointers_p = NULL;

	p_variable_frequency_digital_source_managed_storage
		managed_storage_p = NULL;

	// cast unmanaged user storage
	default_pointers_p = (p_variable_frequency_digital_source_default_pointers)device_p->unmanaged_user_storage;

	// cast managed storage
	managed_storage_p = (p_variable_frequency_digital_source_managed_storage)device_p->user_storage;

	// set initial condition
	rv = variable_frequency_digital_source_set_initial_condition_single_output_from_IC_parameter( context_p, device_p );

	// schedule initial wake event
	rv = context_p->funcs->set_scheduled_wake( device_p, default_pointers_p->parameter_values_p->DELAY, &( identifier ) );
	
}
