// P_term.v
//
//	Module for computing the P-term output of the PID filter
//
`timescale 1ps/1fs

module P_term(
    output reg signed [19:0] out,	// P-term output, a 20-bit signed integer
    input wire signed [9:0]  err_n0,	// Current error, a 10-bit signed integer
    input wire signed [9:0]  iKP ) ;	// 16 * KP stored as a 10-bit signed integer

    parameter delay = 10;

    initial begin
	out = 0;
    end

    always @ ( err_n0 ) begin
	out <= #(delay) iKP * err_n0;
    end

endmodule
