// PID_compensator.v

`include "../Verilog_lib/PID_coefficients.v"
`include "../Verilog_lib/P_term.v"
`include "../Verilog_lib/I_term.v"
`include "../Verilog_lib/D_term.v"
`include "../Verilog_lib/PID_sum_terms.v"

`timescale 1ps/1fs


module PID_compensator(
    output wire signed [19:0] PID_out,
    input clk_dly,			// Clock signal for unit delay
    input clk_integ,			// Clock signal for integration, also used
					//   for the low-pass filter in the
					//   differentiation.
    input clk_pid_out,			// Clock signal for updating the PID output
    input wire signed [9:0] err_n0 );	// Current error, a 10-bit signed integer

    reg  signed [9:0] err_n1;		// Previous error, a 10-bit signed integer
    wire signed [19:0] P_out;		// Output of the P-term, a 20-bit signed integer
    wire signed [23:0] I_out;		// Output of the I-term, a 24-bit signed integer
    wire signed [23:0] D_out;		// Output of the D-term, a 24-bit signed integer

    wire signed [9:0]  iKP;		// 10-bit signed iKP storing 16 * KP
    wire signed [9:0]  iKI;		// 10-bit signed iKI storing 2048 * KI
    wire signed [13:0] iKD;		// 14-bit signed iKD storing 16 * KD

    parameter KP = 10.02;
    parameter KI = 0.1329;
    parameter KD = 261.6;
    parameter initial_duty = 0.25195;


    parameter gate_delay = 10;
    parameter reg_delay  = 20;

    initial begin
	err_n1 = 0;
//	$monitor( "Time: %8d, initial_duty=%.6e, PID_out=%d", $time, initial_duty, PID_out );
//	$monitor( "Time: %8d, iKP=%d, iKI=%d, iKD=%d", $time, iKP, iKI, iKD );
//	$monitor( "Time: %8d, err_n0=%d, err_n1=%d P_out=%d, I_out=%d, D_out=%d", $time, err_n0, err_n1, P_out, I_out, D_out );
//	$simplis_vpi_probe( clk_dly );
//	$simplis_vpi_probe( clk_integ );
//	$simplis_vpi_probe( err_n0 );
	$simplis_vpi_probe( PID_out );
//	$simplis_vpi_probe( err_n1 );
//	$simplis_vpi_probe( P_out );
//	$simplis_vpi_probe( I_out );
//	$simplis_vpi_probe( D_out );
    end


    // Previous error err_n1 is produced whenever the +ve edge of clk_dly arrives
    always @( posedge clk_dly ) begin
	err_n1 <= #(reg_delay) err_n0;
    end

    PID_coefficients #( .KP(KP), .KI(KI), .KD(KD) )
	U_PID_coefficients( .iKP(iKP), .iKI(iKI), .iKD(iKD) );

    P_term #( .delay(gate_delay) )
	U_P_term( .out(P_out), .err_n0(err_n0), .iKP(iKP) );

    I_term #( .delay(reg_delay), .initial_duty(initial_duty) )
	U_I_term( .out(I_out), .clk(clk_integ), .err_n0(err_n0), .err_n1(err_n1), .iKI(iKI) );

    D_term #( .delay(reg_delay) )
	U_D_term( .out(D_out), .clk(clk_integ), .err_n0(err_n0), .err_n1(err_n1), .iKD(iKD) );

    PID_sum_terms #( .delay(reg_delay), .initial_duty(initial_duty) )
	U_PID_sum_terms( .out(PID_out), .clk(clk_pid_out), .P_out(P_out), .I_out(I_out), .D_out(D_out) );

endmodule
